<?php
require_once '../../config.php';
require_once ROOT . 'app/db.php';

$daireler = db::execAll("
    SELECT d.*, a.apartman_adi
    FROM tb_daire d
    LEFT JOIN tb_apartman a ON a.ID=d.apartmanID
    WHERE d.aktif=1
    ORDER BY d.apartmanID ASC,d.kat ASC
");

require_once ROOT . 'layout/header.php';
require_once ROOT . 'layout/sidebar.php';
?>

<div class="flex-fill p-4">
    <div class="d-flex justify-content-between mb-3">
        <h4>Daireler</h4>
        <a href="ekle.php" class="btn btn-primary btn-sm">+ Yeni Daire</a>
    </div>

    <table class="table table-bordered table-hover align-middle">
        <thead class="table-dark">
            <tr>
                <th>#</th>
                <th>Apartman</th>
                <th>Daire No</th>
                <th>Kat</th>
                <th>Malik</th>
                <th>Telefon</th>
                <th>İşlem</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($daireler as $d): ?>
                <tr>
                    <td><?= $d->ID ?></td>
                    <td><?= $d->apartman_adi ?></td>
                    <td><?= $d->daire_no ?></td>
                    <td><?= $d->kat ?></td>
                    <td><?= $d->malik_adi ?></td>
                    <td><?= $d->telefon ?></td>
                    <td>
                        <a href="duzenle.php?id=<?= $d->ID ?>" class="btn btn-sm btn-warning">Düzenle</a>
                        <a href="pasif.php?id=<?= $d->ID ?>" onclick="return confirm('Pasif yapılsın mı?')" class="btn btn-sm btn-danger">Pasif</a>
                        <a href="borc.php?daireID=<?= $d->ID ?>" class="btn btn-sm btn-outline-primary">Borç Detayı</a>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php require_once ROOT . 'layout/footer.php'; ?>